<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Upgrade code for install
 *
 * @package   assignsubmission_ctsubmission
 * @copyright 2021 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
require_once(__DIR__ . '/upgradelib.php');

defined('MOODLE_INTERNAL') || die();

use assignsubmission_ctsubmission\shared_lib as NED;

/**
 * Stub for upgrade code
 * @param int $oldversion
 * @return bool
 */
function xmldb_assignsubmission_ctsubmission_upgrade($oldversion) {
    global $DB;

    $dbman = $DB->get_manager();

    if ($oldversion < 2022041201){
        /** @see assignsubmission_ctsubmission_update_deadlines() */
        local_ned_controller\task\disposable_adhoc_task::add_new_job('assignsubmission_ctsubmission_update_deadlines',
            '', '', [], 0, null,
            __DIR__ . '/upgradelib.php'
        );
        NED::ctrl_admin_alert_rem('err_deadlines_fail');
        NED::ctrl_admin_alert_add('warn_deadlines_updating', NED::NOTIFY_WARNING);

        upgrade_plugin_savepoint(true, 2022041201, 'assignsubmission', 'ctsubmission');
    }

    return true;
}
