<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * CT submission.
 *
 * @package   assignsubmission_ctsubmission
 * @copyright 2021 Michael Gardener <mgardener@cissq.com>
 * @license   http://www.gnu.org/copyleft/gpl.html gnu gpl v3 or later
 */

use assignsubmission_ctsubmission\shared_lib as NED;

require_once(dirname(__FILE__, 5) . '/config.php');
/** @var object $CFG */
require_once($CFG->dirroot . '/mod/assign/locallib.php');

$id = required_param('id', PARAM_INT);
$groupid = optional_param('groupid', 0, PARAM_INT);

list ($course, $cm) = get_course_and_cm_from_cmid($id, 'assign');

require_login($course, true, $cm);
$context = $cm->context;
require_capability('assignsubmission/ctsubmission:submit', $context);

$assign = new assign($context, $cm, $course);

/** @var assign_submission_ctsubmission $assignsubmissionct */
$assignsubmissionct  = $assign->get_submission_plugin_by_type('ctsubmission');
$cfg = $assignsubmissionct->get_config();

if (empty($cfg->enabled)) {
    NED::print_error('invalidmodule');
}

$urlparams = array('id' => $id);

$url = NED::url('~/submission.php', $urlparams);
NED::page_set_title('submission', $url);

$submission = new \assignsubmission_ctsubmission\output\ct_submission($assign, $groupid);

echo $OUTPUT->header();
echo NED::render($submission);
echo $OUTPUT->footer();
