<?php
/**
 * @package    assignsubmission_proxy
 * @subpackage NED
 * @copyright  2022 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use assignsubmission_proxy\shared_lib as NED;

function assignsubmission_proxy_update_deadlines(){
    mtrace('assignsubmission_proxy_update_deadlines start');
    $error = false;
    NED::ctrl_admin_alert_add('warn_deadlines_updating', NED::NOTIFY_WARNING);
    try {
        $configs = NED::dm_get_all_proxy_configs(NED::$PLUGIN_NAME);
        $c = count($configs);
        mtrace("There are $c activities to update, processing...");
        NED::dm_update_proxy_overrides($configs, true);
    } catch (\Exception $ex){
        $error = true;
        /** @see default_exception_handler() */
        abort_all_db_transactions();
        $info = get_exception_info($ex);
        echo \bootstrap_renderer::early_error($info->message, $info->moreinfourl, $info->link, $info->backtrace, $info->debuginfo, $info->errorcode);
    }

    NED::ctrl_admin_alert_rem('warn_deadlines_updating');
    if ($error){
        NED::ctrl_admin_alert_add('err_deadlines_fail', NED::NOTIFY_ERROR);
    } else {
        NED::ctrl_admin_alert_rem('err_deadlines_fail');
    }

    mtrace('assignsubmission_proxy_update_deadlines end');
}
