<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'flashcard', language 'en'
 *
 * @package     mod_flashcard
 * @category    mod
 * @copyright   Valery Fremaux, Tomasz Muras
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// Capabilities.
$string['flashcard:manage'] = 'Gérer les jeux';
$string['flashcard:canplayfree'] = 'Jouer en mode libre';
$string['flashcard:addinstance'] = 'Ajouter un flashcard';

$string['addone'] = 'Ajouter une question';
$string['addthree'] = 'Ajouter trois questions';
$string['answer'] = 'Réponses';
$string['answersmediatype'] = 'Type de média des réponses&ensp;';
$string['audiostart'] = 'Démarre les sons automatiquement';
$string['autodowngrade'] = 'Activer l\'érosion des jeux&ensp;';
$string['avgaccess'] = 'Accès moyen par carte ';
$string['backside'] = 'Arrière de la carte';
$string['backtocourse'] = 'Revenir au cours';
$string['backtodecks'] = 'Revenir à la table de jeu';
$string['badcards'] = 'Carte(s) rejetée(s)&nbsp;:&ensp;';
$string['bycards'] = 'Par cartes';
$string['byusers'] = 'Par étudiant';
$string['card'] = 'Carte';
$string['cardback'] = 'Dos de la carte';
$string['cardfront'] = 'Face de la carte';
$string['cardsep'] = 'Séparateur entre cartes&nbsp;:&ensp;';
$string['cardsindeck'] = 'Carte(s) restante(s)&nbsp;:&ensp;{$a}';
$string['cardsread'] = 'Carte(s) détectée(s)&nbsp;:&ensp;';
$string['cardsremaining'] = 'Cartes restantes&ensp;';
$string['commands'] = '';
$string['completionallgoodenabled'] = 'Les étudiants ont migré toutes les cartes dans le dernier jeu';
$string['completionallgoodgroup'] = 'Toutes connues';
$string['completionallgoodhelp'] = 'Nécessite que toutes les cartes soient dans le paquet le plus facile';
$string['completionallviewed'] = 'Nécessite que toutes les cartes aient été vues une fois ou au moins (cartes)&nbsp;:&ensp;';
$string['completionallviewedgroup'] = 'Parcouru une fois';
$string['completiondiscussionshelp'] = 'requiring that all cards are viewed at least once';
$string['confirm'] = 'Confirmer&nbsp;:&ensp;';
$string['counters'] = 'Compteurs';
$string['crontask'] = 'Erosion des révisions';
$string['customisationfiles'] = 'Fichiers de personnalisation des cartes';
$string['deck'] = 'Paquet de cartes';
$string['deck1_delay'] = 'Délai de relance (jeu 1)&ensp;';
$string['deck2_delay'] = 'Délai de relance (jeu 2)&ensp;';
$string['deck2_release'] = 'Délai d\'érosion (jeu 2)&ensp;';
$string['deck3_delay'] = 'Délai de relance (jeu 3)&ensp;';
$string['deck3_release'] = 'Délai d\'érosion (jeu 3)&ensp;';
$string['deck4_delay'] = 'Délai de relance (jeu 4)&ensp;';
$string['deck4_release'] = 'Délai d\'érosion (jeu 4)&ensp;';
$string['deck_delay'] = 'Délais de révision';
$string['deck_release'] = 'Erosion des paquets';
$string['decks'] = 'Jeux';
$string['deckstates'] = 'Etat des jeux';
$string['deleteselected'] = 'Supprimer les cartes sélectionnées';
$string['deleteselection'] = 'Supprimer la sélection';
$string['difficultcards'] = 'Cartes difficiles';
$string['easycards'] = 'Cartes faciles';
$string['edit'] = 'Modifier les cartes';
$string['editingcards1'] = 'Editer le jeu de cartes';
$string['editingcards2'] = 'Editer le jeu de cartes';
$string['emptydeck'] = 'Image pour le jeu "vide"';
$string['emptyset'] = 'Jeu vide';
$string['endtime'] = 'Fin de disponibilité&ensp;';
$string['erroraddcard'] = 'Impossible d\'ajouter une carte au jeu';
$string['errorbindcard'] = 'Impossible de lier la carte au jeu de {$a}';
$string['errordeletecard'] = 'Impossible de supprimer la carte';
$string['errorupdatecard'] = 'Impossible de modifier la carte';
$string['extracss'] = 'CSS additionnelle';
$string['fieldsep'] = 'Séparateur de champ&nbsp;:&ensp;';
$string['flashcardneedsreview'] = 'Un flashcard demande une révision';
$string['flipdeck'] = 'Inverser questions/réponses';
$string['forcereload'] = 'Forcer le rechargement ';
$string['freegame'] = 'Usage libre';
$string['freeplayinstructions'] = 'Trouvez la réponse à la question posée, retournez la carte, et contrôlez votre réponse. Vous pouvez retirer la carte du jeu ou tester d\'autres cartes. Le paquet vous est présenté dans un ordre aléatoire. Révisez tout le paquet si possible en une fois.';
$string['frontside'] = 'Dessus de la carte';
$string['goodcards'] = 'Carte(s) correcte(s)&nbsp;:&ensp;';
$string['havetologin'] = 'Vous devez être identifié pour pouvoir soumettre un choix';
$string['ifailed'] = 'J\'ai répondu faux';
$string['igotit'] = 'J\'ai répondu juste';
$string['image'] = 'image';
$string['imageplussound'] = 'image + son';
$string['import'] = 'Importer';
$string['importadvice'] = 'En important ces données vous détruisez le jeu existant et toutes les données de consultation des participants';
$string['imported'] = 'Import&nbsp;:&ensp;';
$string['importingcards'] = 'Import des cartes';
$string['importreport'] = '<b>Flashcard a importé des nouvelles cartes :</b>';
$string['instructions'] = 'Trouvez la réponse à la question posée, retournez la carte, et contrôlez votre réponse. Indiquez à l\'application votre situation. Le paquet vous est présenté dans un ordre aléatoire. Révisez tout le paquet si possible en une fois.';
$string['lastaccessed'] = 'Dernier accès';
$string['leitnergame'] = 'Usage de Leitner';
$string['matchingquestion'] = 'Question du quizz à utiliser';
$string['maxaccess'] = 'Accès à la carte la plus vue ';
$string['mediatypes'] = 'Type de média';
$string['mediumeffortcards'] = 'Cartes moyennes';
$string['minaccess'] = 'Accès à la carte la moins vue&ensp;';
$string['missingimage'] = '{Image non disponible}';
$string['missingsound'] = '{Fichier son non disponible}';
$string['missingvid'] = '{Fichier video manquant}';
$string['models'] = 'Modèles d\'interaction';
$string['models_help'] = 'Permet de choisir le ou les modèles d\'interaction à activer';
$string['bothmodels'] = 'Leitner et révision libre';
$string['leitner'] = 'Entrainement de Leitner';
$string['freeuse'] = 'Entrainement libre';
$string['modulename'] = 'Jeu de cartes flash';
$string['modulenameplural'] = 'Cartes flash';
$string['next'] = 'Carte suivante';
$string['nocards'] = 'Pas de cartes dans le flashcard.';
$string['noflashcards'] = 'Aucune activité du type "cartes flash" dans ce cours.';
$string['nomorecards'] = 'Plus de cartes dans ce jeu.';
$string['nosubquestions'] = 'Erreur: Cette question n\'a pas de sous-options&nbsp;!';
$string['notinitialized'] = 'Cet étudiant n\'a jamais utilisé ce flashcard.';
$string['notifications'] = 'Notifications';
$string['nousers'] = 'Aucun étudiant dans ce cours.';
$string['num'] = 'N°';
$string['numericrequired'] = 'Un nombre est requis.';
$string['outoftimerange'] = 'Ce module est soumis à une temporisation. Vous ne pouvez pas l\'utiliser maintenant.';
$string['playwithme'] = 'Apprendre ce paquet';
$string['pluginadministration'] = 'Administration du Flashcard';
$string['pluginname'] = 'Cartes Flash';
$string['previous'] = 'Carte précédente';
$string['question'] = 'Questions';
$string['questionid'] = 'Question d\'appariement source&ensp;';
$string['questionsmediatype'] = 'Type de média des questions&ensp;';
$string['reinforce'] = 'Réviser ce paquet';
$string['remindusers'] = 'Rappeler les révisions';
$string['removecard'] = 'Retirer la carte du jeu';
$string['reset'] = 'Réinitialiser le paquet';
$string['resetflashcardstates'] = 'Supprimer les données de révision';
$string['reviewback'] = 'Image pour le jeu "à réviser"';
$string['reviewedback'] = 'Image pour le jeu "révisé"';
$string['reviewedempty'] = 'Image pour un paquet vide';
$string['sound'] = 'son';
$string['starttime'] = 'Début de disponibilité ';
$string['stylesheet'] = 'Téléchargez la feuille de style';
$string['styling'] = 'Personnalisation&ensp;';
$string['sumaccess'] = 'Total cartes vues ';
$string['summary'] = 'Description du jeu de cartes flash';
$string['teachersummary'] = 'Bilan';
$string['text'] = 'texte';
$string['timetoreview'] = 'Il reste {$a} jours avant la révision';
$string['trivialcards'] = 'Cartes évidentes';
$string['undefinedquestionset'] = 'Aucun jeu de questions n\'a été défini pour ce jeu flash';
$string['userdecks'] = 'Paquets des utilisateurs';
$string['userdecksummary'] = 'Jeu {$a->deckid}: {$a->count} cartes {$a->cardcount} hits en tout sur le jeu)';
$string['viewed'] = 'Affichages';
$string['video'] = 'Vidéo';

$string['privacy:metadata:flashcard_card:userid'] = 'L\'identifiant de l\'utilisateur utilisant le flashcard';
$string['privacy:metadata:flashcard_card:flashcardid'] = 'L\'identifiant de l\'instance de flashcard';
$string['privacy:metadata:flashcard_card:entryid'] = 'L\'identfifiant de la carte dans le jeu';
$string['privacy:metadata:flashcard_card:deck'] = 'L\identifiant de la pile de cartes dans laquelle est la carte';
$string['privacy:metadata:flashcard_card:lastaccessed'] = 'La dernière date de tirage de la carte';
$string['privacy:metadata:flashcard_card'] = 'Stocke la composition des piles de cartes pour chaque utilisateur';

$string['privacy:metadata:flashcard_userdeck_state:userid'] = 'L\'identifiant de l\'utilisateur utilisant le flashcard';
$string['privacy:metadata:flashcard_userdeck_state:flashcardid'] = 'L\'identifiant de l\'instance de flashcard';
$string['privacy:metadata:flashcard_userdeck_state:deck'] = 'La pile pour laquelle l\'état est enregistré';
$string['privacy:metadata:flashcard_userdeck_state:state'] = 'L\'état de révision de la pile par l\'utilisateur';
$string['privacy:metadata:flashcard_userdeck_state'] = 'Stocke l\'état de la pile au regard des nécessités de révision de l\'utilisateur';

$string['import_help'] = '
<p>Vous pouvez désormais rapidement charger un flashcard avec un grand nombre de questions/réponses par la fonctionnalité
d\'import en masse. (Seules des fiches texte/texte peuvent être massivement importées). Il vous faut juste constituer un
fichier texte contenant la liste formatée de vos paries de questions/réponses et coller ce texte dans la zone de texte d\'import.
Vous pouvez décider de la forme de ce fichier, sur la base de séparateurs les plus courants, sous Linux ou sous Windows. L\'un des
formats les plus classiques est le format "une paire par ligne", utilisant un deux-points (\':\') ou une virgule comme
séparateur entre les questions et les réponses.</p>
<p>Les questions doivent toujours être placées en premier, et DOIVENT avoir une réponse exprimée. Les lignes blanches ou
vides sont ignorées, ainsi que celles qui commencent par un # ou un /.</p>
<p>La fonction d\'import fera une vérification rapide de ce que vous voulez importer. Elle rejettera les cartes dont le
texte est mal formé et vous indique combien de paires se trouvent en erreur.</p>
<p>L\'import détruira toutes les données anciennes de cartes et toutes les réponses données par les étudiants. Une confirmation
explicite vous est demandée dans le formulaire.</p>';

$string['freegame_help'] = '
<p>En mode "usage libre", vous utilisez le jeu de cartes mémorielles librement à votre guise. Tout le jeu de cartes est
chargé et tiré aléatoirement.</p>
<p>Vous pouvez vous même enlever une carte du jeu lorsque vous pensez que vous n\'en avez plus besoin. Lorsque vous
enlevez cette carte, elle ne réapparaîtra pas dans les tirages ultérieurs, `moins que vous ne réinitialisez le paquet.</p>';

$string['leitnergame_help'] = '
<p>Mise au point par Sebastian Leitner, ingénieur Allemand, en 1970, cette méthode de travail se base sur la répétition espacée
des sollicitations de la mémoire pour renforcer l\'engrammage (la profondeur de la trace d\'une information dans le cerveau).</p>
<p>En mode de Leitner, vous diposez d\'un certain nombre de jeux de cartes placés de gauche `droite par difficulté décroissante.
Au début du jeu, toutes les cartes sont placées dans le jeu de gauche (le jeu difficile). Vous parcourez ce jeu et essayez de trouver
les réponses à chaque carte. Vous indiquez alors au système si vous connaissiez ou ne connaissiez pas la réponse. <br/>
Si vous "connaissez la réponse", la carte se déplace dans le jeu immédiatement à droite. Dans le cas contraire, la carte restera dans
ce paquet. L\'exercice prend fin lorsque toutes les cartes sont parvenues dans le paquet le plus facile.</p>
<p>Le système vous indique les paquets que vous devez réviser quand vous revenez sur le plateau de jeu. C\'est l\'instructeur qui règle
les délais dans lesquels chaque paquet doit être repris. L\'instructeur peut également activer "l\'érosion des paquets", par laquelle si
vous ne venez pas suffisamment souvent réviser vos connaissances, les cartes migrent à nouveau vers les paquets plus difficiles.</p>';

$string['modulename_help'] = '
<p>Ce module permet aux apprenants de mémoriser facilement une liste de "choses". Il s\'agit d\'un exercice typique d\'indexation mentale,
dans lequel une correspondance entre deux ensembles doit être mémorisée. Nous disons "choses" car à la fois l\'index comme la valeur
peuvent être du texte, des images ou du son. </p>
<p>Ce module propose un "système de Leitner" pour "optimiser" l\'apprentissage des correspondances en favorisant les couples plus
difficiles. Les couples d\'objets sont d\'abord rangés dans le premier jeu de cartes. Ils sont tous considérés dès le départ comme
"difficiles" `apprendre. L\'enseignant peut choisir un dispositif d\'apprentissage utilisant 2, 3 ou 4 jeux. On utilisera 4 jeux si
l\'ensemble de couples `apprendre est important. </p>
<p>Lorsque l\'apprenant échoue à répondre à une question, il informe le jeu et la carte reste dans le même paquet. S\'il répond juste,
il l\'indique au système qui passe la carte au jeu suivant, réunissant les cartes moins difficiles `apprendre. Le même procédé est
appliqué `tous les jeux, jusqu\' à ce que toutes les cartes aient atteint le paquet le plus facile. La table de jeu indique aux
apprenants quels paquets doivent être révisés. Les paquets plus difficiles seront proposés plus souvent que les paquets plus "simples".
Les périodes de réactivation des paquets pour une révision sont ajustables. </p>
<p>Lorsqu\'un apprenant ne vient pas réviser ses paquets de cartes, il est possible de faire remonter ces dernières automatiquement
dans les paquets supérieurs (érosion des jeux de cartes).</p>
<p>Ce module permet également un usage libre du jeu de cartes, si la configuration du module (par les capacités) le permet. L\'enseignant
peut modifier graphiquement l\'apparence des cartes en proposant une CSS et un jeu d\'images personnalisées.</p>';

$string['sourcequestion_help'] = '
<p>Il est possible de constituer rapidement un jeu de cartes à partir d\'une question d\'appariement de la banque de questions.
Pour cela, choisissez ici une question et cochez la case "forcer le rechargement". Les précédentes cartes seront effacées et
les données des cartes seront récupérées de l\'entrée de questionnaire.
Attention : modifier par la suite les cartes `partir de l\'éditeur de cartes ne modifie pas la question d\'appariement dans
la banque de questions.';

$string['forcereload_help'] = '
<p>Cette case à cocher force le module à recharger complètement la définition des cartes en se basant sur les données entrées
pour une question de type "appariement" de la base de questions.</p>
<p>Toutes les données de consultations et les situations des apprenants antérieures sont effacées.</p>';

$string['mediatypes_help'] = '
<p>Cette liste permet de définir le type de média utilisé pour les questions. </p>
<ul><li><b>Texte :</b> Le texte entré est littéralement imprimé sur les cartes.</li>
<li><b>Image :</b> Le texte entré correspond à la localisation d\'un fichier image sur le serveur, pris dans les fichiers du
cours. Un bouton de recherche de fichier permet de lier aisément une ressource graphique.</li>
<li><b>Son :</b> Le texte entré correspond à la localisation d\'un fichier sonore sur le serveur, pris dans les fichiers du
cours. Un bouton de recherche de fichier permet de lier aisément une ressource sonore. Lors de la présentation des cartes,
le lecteur de son par défaut du navigateur est utilisé.</li><ul></p>';

$string['decks_help'] = '
<p>Permet de choisir entre 2, 3, et 4 jeux. </p>
<p>Le système de Leitner typique utilise 3 jeux. 4 jeux correspondent à un cycle de mémorisation plus long et convient à
un nombre de cartes importantes. On peut utiliser deux jeux sur des toutes petites séries de cartes ou des associations
faciles à mémoriser.</p>
';

$string['autodowngrade_help'] = '
<p>Cette option permet d\'activer l\'érosion automatique des jeux. Un jeu s\'érode si l\'apprenant ne vient pas réviser
le jeu dans les temps impartis (voir : délai d\'érosion). Les cartes qui sont trop anciennes remontent dans les paquets
plus difficiles, jusqu\' à revenir dans le premier paquet. La vitesse d\'érosion dépend du réglage des divers délais pour
chaque paquet.</p>
';

$string['flipdeck_help'] = '
<p>Permet la réversibilité du jeu de cartes. Si cette option est activée, alors les questions sont placées au dos des
cartes comme réponses et vice-versa.</p>
';

$string['deck_delay_help'] = '
<p>Ce délai permet d\'ajuster le temps au bout duquel le paquet est marqué comme devant être révisé. Le temps de référence
est celle de la plus ancienne carte non révisée dans le paquet. </p>
<p>Le temps est exprimé en "heures".</p>
';

$string['deck_release_help'] = '
<p>Ce délai permet d\'ajuster le temps au bout duquel, après la relance du paquet, les cartes remontent automatiquement
dans le paquet supérieur. Chaque paquet peut être réglé différement. Le paquet le plus difficile ne peut s\'éroder puisque
les cartes ne peuvent remonter plus "haut". Il n\'y a donc pas de réglage pour ce paquet. </p>
<p>Le temps est exprimé en "heures".
';

$string['notify_review_tpl'] = '
Bonjour <%%FULLNAME%%>

Un flashcard nécessite votre attention. Vous avez des cartes à réviser
dans le cours <%%COURSE%%> :

<%%URL%%>';

$string['notify_review_html_tpl'] = '
<p>Bonjour <%%FULLNAME%%></p>

<p>Un flashcard nécessite votre attention. Vous avez des cartes à réviser
dans le cours <b><%%COURSE%%></b> : </p>

<a href="<%%URL%%>"><%%URL%%></a>';

