<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * All the steps to restore mod_nedactivitycluster are defined here.
 *
 * @package     mod_nedactivitycluster
 * @category    restore
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();


/**
 * Defines the structure step to restore one mod_nedactivitycluster activity.
 */
class restore_nedactivitycluster_activity_structure_step extends restore_activity_structure_step {

    /**
     * Defines the structure to be restored.
     *
     * @return restore_path_element[].
     */
    protected function define_structure() {
        $paths = array();

        $paths[] = new restore_path_element('nedactivitycluster', '/activity/nedactivitycluster');
        $paths[] = new restore_path_element('nedactivitycluster_cluster', '/activity/nedactivitycluster/clusters/cluster');

        return $this->prepare_activity_structure($paths);
    }

    /**
     * Processes the nedactivitycluster restore data.
     *
     * @param array $data Parsed element data.
     */
    protected function process_nedactivitycluster($data) {
        global $DB;

        $data = (object)$data;
        $oldid = $data->id;
        unset($data->id);

        $data->course = $this->get_courseid();

        $newid = $DB->insert_record('nedactivitycluster', $data);
        $this->apply_activity_instance($newid);
    }

    /**
     * Processes the activitycluster restore data.
     *
     * @param array $data Parsed element data.
     */
    protected function process_nedactivitycluster_cluster($data) {
        global $DB;

        $data = (object)$data;
        $oldid = $data->id;
        unset($data->id);

        $data->nedactivitycluster = $this->get_new_parentid('nedactivitycluster');
        $data->timemodified = $this->apply_date_offset($data->timemodified);

        $newid = $DB->insert_record('nedactivitycluster_clusters', $data);
        $this->set_mapping('nedactivitycluster_cluster', $oldid, $newid);
    }

    /**
     * Defines post-execution actions.
     */
    protected function after_execute() {
        $this->add_related_files('mod_nedactivitycluster', 'intro', null);
        $this->add_related_files('mod_nedactivitycluster', 'summary', null);
    }
}
