<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Prints an instance of mod_nedactivitycluster.
 *
 * @package     mod_nedactivitycluster
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require_once($CFG->libdir.'/formslib.php');

class cluster_form extends moodleform {
    public function definition() {

        $mform = $this->_form;
        $customdate = $this->_customdata;

        $mform->addElement('header', '', get_string('cluster', 'nedactivitycluster'), '');

        $mform->addElement('text', 'name', get_string('title', 'nedactivitycluster'), array('size' => '60'));
        $mform->setType('name', PARAM_TEXT);
        $mform->addRule('name', null, 'required', null, 'client');

        $mform->addElement('editor', 'summary', get_string('description', 'nedactivitycluster'));
        $mform->setType('summary', PARAM_RAW);

        // Activity selection.
        $modinfo = get_fast_modinfo($customdate['courseid']);
        $sections = $modinfo->get_section_info_all();
        $activities = $modinfo->get_cms();
        $excludedmodules = nedactivitycluster_excluded_modules();

        foreach ($sections as $section) {
            if ($section->sequence) {
                if (trim($section->__get('name') ?? '')) {
                    $sectiontitle = trim($section->__get('name'));
                } else {
                    $sectiontitle = get_string('defaultsectionname', 'nedactivitycluster', $section->section);
                }

                $mform->addElement('advcheckbox', 'section'.$section->section, '', $sectiontitle, array('group' => $section->section), array(0, $section->section + 1));
                $sectionmods = explode(",", $section->sequence);
                foreach ($sectionmods as $sectionmod) {
                    if (!empty($activities[$sectionmod])) {
                        $mod = $activities[$sectionmod];
                        if ($excludedmodules && in_array($mod->modname, $excludedmodules)) {
                            continue;
                        }
                        $mform->addElement('advcheckbox', 'activity'.$mod->id, '',
                            nedactivitycluster_activity_name_formatter($mod->name, $mod->modname),
                            array('group' => $section->section), array(0, $mod->id));
                    }
                }
            }
        }

        $mform->addElement('hidden', 'id');
        $mform->setType('id', PARAM_INT);

        $mform->addElement('hidden', 'cmid');
        $mform->setType('cmid', PARAM_INT);

        $this->add_action_buttons(true, get_string('submit', 'nedactivitycluster'));
    }

    public function validation($data, $files) {
        $errors = array();
        return $errors;
    }
}