<?php
/**
 * @package    mod_nedactivitycluster
 * @subpackage NED
 * @copyright  2024 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/**
 * All upgrades checks from Moodle 3
 *
 * @param int $oldversion
 */
function nedactivitycluster_moodle3_upgrades($oldversion): void{
    global $DB;
    $dbman = $DB->get_manager();

    if ($oldversion < 2018061601) {
        // Define field showgrade to be added to nedactivitycluster.
        $table = new xmldb_table('nedactivitycluster');
        $field = new xmldb_field('showgrade', XMLDB_TYPE_INTEGER, '1', null, XMLDB_NOTNULL, null, '1', 'showpassfailbackgroundcolors');

        // Conditionally launch add field showgrade.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field showstudentmenu to be added to nedactivitycluster.
        $table = new xmldb_table('nedactivitycluster');
        $field = new xmldb_field('showstudentmenu', XMLDB_TYPE_INTEGER, '1', null, XMLDB_NOTNULL, null, '1', 'showgrade');

        // Conditionally launch add field showstudentmenu.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Nedactivitycluster savepoint reached.
        upgrade_mod_savepoint(true, 2018061601, 'nedactivitycluster');
    }

    if ($oldversion < 2018061900) {
        // Define field showgrade to be added to nedactivitycluster.
        $table = new xmldb_table('nedactivitycluster');
        $field = new xmldb_field('showtitleheader', XMLDB_TYPE_INTEGER, '1', null, XMLDB_NOTNULL, null, '1', 'showstudentmenu');

        // Conditionally launch add field showgrade.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Nedactivitycluster savepoint reached.
        upgrade_mod_savepoint(true, 2018061900, 'nedactivitycluster');
    }

    if ($oldversion < 2022112101) {

        $table = new xmldb_table('nedactivitycluster');

        // Define field pulldatafromquestionnaire to be added to nedactivitycluster.
        $field = new xmldb_field('pulldatafromquestionnaire', XMLDB_TYPE_INTEGER, '1', null, XMLDB_NOTNULL, null, '0', 'allactivitiesmustbecompleted');

        // Conditionally launch add field pulldatafromquestionnaire.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field questionnairequestionname to be added to nedactivitycluster.
        $field = new xmldb_field('questionnairequestionname', XMLDB_TYPE_CHAR, '255', null, XMLDB_NOTNULL, null, null, 'pulldatafromquestionnaire');

        // Conditionally launch add field questionnairequestionname.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field questionnametoshow to be added to nedactivitycluster.
        $field = new xmldb_field('questionnametoshow', XMLDB_TYPE_CHAR, '255', null, XMLDB_NOTNULL, null, null, 'questionnairequestionname');

        // Conditionally launch add field questionnametoshow.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field calculatetotal to be added to nedactivitycluster.
        $field = new xmldb_field('calculatetotal', XMLDB_TYPE_INTEGER, '1', null, XMLDB_NOTNULL, null, '0', 'questionnametoshow');

        // Conditionally launch add field calculatetotal.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field calculatetargettotal to be added to nedactivitycluster.
        $field = new xmldb_field('calculatetargettotal', XMLDB_TYPE_INTEGER, '1', null, XMLDB_NOTNULL, null, '0', 'calculatetotal');

        // Conditionally launch add field calculatetargettotal.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Nedactivitycluster savepoint reached.
        upgrade_mod_savepoint(true, 2022112101, 'nedactivitycluster');
    }
}
