<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Plugin administration pages are defined here.
 *
 * @package     mod_nedactivitycluster
 * @category    admin
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot . '/mod/nedactivitycluster/lib.php');

if ($ADMIN->fulltree) {
    $passgradeoptions = array(
        NEDACTIVITYCLUSTER_ACTIVITYSETTING => get_string('useactivitysetting', 'nedactivitycluster'),
        NEDACTIVITYCLUSTER_PASSGRADEPERCENT => get_string('usepassgradepercent', 'nedactivitycluster'),
    );
    $settings->add(
        new admin_setting_configselect(
            'nedactivitycluster/passgrade',
            get_string('passgrade', 'nedactivitycluster'),
            '',
            NEDACTIVITYCLUSTER_ACTIVITYSETTING,
            $passgradeoptions
        )
    );
    $settings->add(
        new admin_setting_configtext(
            'nedactivitycluster/passgradepercent',
            get_string('passgradepercent', 'nedactivitycluster'),
            '',
            50,
            PARAM_INT
        )
    );

    $showmodoptions = array(
        NEDACTIVITYCLUSTER_SHOW_ACTIVITIES => get_string('showactivities', 'nedactivitycluster'),
        NEDACTIVITYCLUSTER_SHOW_RESOURCES => get_string('showresources', 'nedactivitycluster'),
        NEDACTIVITYCLUSTER_SHOW_BOTH => get_string('showboth', 'nedactivitycluster'),
    );
    $settings->add(
        new admin_setting_configselect(
            'nedactivitycluster/showmod',
            get_string('show', 'nedactivitycluster'),
            '',
            NEDACTIVITYCLUSTER_SHOW_ACTIVITIES,
            $showmodoptions
        )
    );
}
