<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * onedrivetoken
 *
 * @package     report_ghs
 * @copyright   2020 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace report_ghs;

defined('MOODLE_INTERNAL') || die();

class onedrivetoken {
    private $clientId;
    private $username;
    private $password;
    private $contentType = "application/x-www-form-urlencoded";
    private $grantType = "password";
    private $endpoint = "https://login.microsoftonline.com/common/oauth2/token";
    private $resource = "https%3A%2F%2Fgraph.microsoft.com%2F";
    public $graphClient;
    public $clientSecret;

    public function __construct($clientid, $clientsecret, $username, $password) {
        $this->clientId     = $clientid;
        $this->clientSecret = $clientsecret;
        $this->username     = $username;
        $this->password     = $password;
    }

    public function getAccessToken() {
        $body = "grant_type=".$this->grantType
                ."&resource=".$this->resource
                ."&client_id=".$this->clientId
                ."&client_secret=".$this->clientSecret
                ."&username=".$this->username
                ."&password=".$this->password;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->endpoint);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
        curl_setopt($ch, CURLOPT_FAILONERROR, 0);
        //curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0); // turns off SSL check,
        //curl_setopt($ch, CURLOPT_PROXY, "127.0.0.1:8888"); // need for fiddler + auth
        curl_setopt($ch, CURLOPT_HTTPHEADER, array($this->contentType, 'Content-Length: ' . strlen($body)));

        $result = curl_exec ($ch);
        $token = json_decode($result, true)['access_token'];
        curl_close($ch);

        return $token;
    }
}
