<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Scheduled task
 *
 * @package     report_ghs
 * @copyright   2019 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace report_ghs\task;

use report_ghs\helper;

defined('MOODLE_INTERNAL') || die();

/**
 * Class update_reports
 * @package report_ghs\task
 */
class update_reports extends \core\task\scheduled_task {

    /**
     * @return string
     */
    public function get_name() {
        return get_string('updatereports', 'report_ghs');
    }

    /**
     * @return bool
     */
    public function execute() {

        $ghs_reports = [
            'adhoc_ghs_grades_report',
            'adhoc_ghs_sla_report',
            'adhoc_ghs_enrollment_report',
            'adhoc_ghs_group_enrollment_report',
            'adhoc_ghs_missed_grade_report',
            'adhoc_ghs_grade_comparisons_report',
            'adhoc_ghs_dm_overview_report',
            'adhoc_ghs_submissions_report',
            'adhoc_ghs_grade_changes_report',
        ];
        $this->queue_adhoc_tasks($ghs_reports);

        $client = helper::get_onedrive_client();
        if (!$client){
            mtrace(' - Pass export tasks');
            return true;
        }

        $ghs_reports_export = [
            'adhoc_ghs_grades_export',
            'adhoc_ghs_sla_export',
            'adhoc_ghs_enrollment_export',
            'adhoc_ghs_group_enrollment_export',
            'adhoc_ghs_missed_grade_export',
            'adhoc_ghs_grade_comparisons_export',
            'adhoc_ghs_dm_overview_export',
            'adhoc_ghs_submissions_export',
            'adhoc_ghs_grade_changes_export',
        ];
        $this->queue_adhoc_tasks($ghs_reports_export);
        return true;
    }

    /**
     * @param string[] $class_list
     */
    public function queue_adhoc_tasks($class_list){
        global $CFG;

        foreach ($class_list as $class_name){

            if (!empty($CFG->ghs_report_disable_tasks && in_array($class_name, $CFG->ghs_report_disable_tasks))) {
                mtrace("$class_name is disabled via config.php!");
                continue;
            }

            $class_name = "\\report_ghs\\task\\$class_name";

            if (!class_exists($class_name)){
                mtrace('There is no class "'.$class_name.'", pass');
                continue;
            }

            $adhoctask = new $class_name();
            $adhoctask->set_custom_data(['timecreated' => time()]);
            $adhoctask->set_blocking(true);
            \core\task\manager::queue_adhoc_task($adhoctask, true);
            mtrace('Queue "'.$class_name.'"');
        }
    }
}
