<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * IMPORT
 *
 * @package     report_ghs
 * @copyright   2019 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
require_once($CFG->libdir.'/adminlib.php');
require_once($CFG->dirroot . '/report/ghs/lib.php');

require_login();

$context = context_system::instance();
require_capability('report/ghs:uploadgroupenrollment', $context);

$pagetitle = get_string('import', 'report_ghs');

$url = new moodle_url("/report/ghs/import.php");
$redirecturl = new moodle_url("/report/ghs/ghs_group_enrollment.php");

$PAGE->set_context($context);
$PAGE->set_url($url);
$PAGE->set_title($pagetitle);
$PAGE->set_pagelayout('report');
$PAGE->set_heading($pagetitle);
$PAGE->navbar->add(get_string('pluginname', 'report_ghs'));
$PAGE->navbar->add(get_string('ghsenrollment', 'report_ghs'), new moodle_url('/report/ghs/ghs_enrollment.php'));
$PAGE->navbar->add($pagetitle);

$form = null;
if (optional_param('needsconfirm', 0, PARAM_BOOL)) {
    $form = new \report_ghs\form\import($url->out(false));
} else if (optional_param('confirm', 0, PARAM_BOOL)) {
    $importer = new \report_ghs\enrollment_importer();
    $form = new \report_ghs\form\import_confirm(null, $importer);
} else {
    $form = new \report_ghs\form\import($url->out(false));
}

if ($form->is_cancelled()) {
    $form = new \report_ghs\form\import($url->out(false));
} else if ($data = $form->get_data()) {

    if (!isset($data->header0)) {
        $data->header0 = optional_param('header0', 0, PARAM_INT);
    }
    if (!isset($data->header1)) {
        $data->header1 = optional_param('header1', 0, PARAM_INT);
    }
    if (!isset($data->header2)) {
        $data->header2 = optional_param('header2', 0, PARAM_INT);
    }
    if (!isset($data->header3)) {
        $data->header3 = optional_param('header3', 0, PARAM_INT);
    }
    if (!isset($data->header4)) {
        $data->header4 = optional_param('header4', 0, PARAM_INT);
    }
    if (!isset($data->header5)) {
        $data->header5 = optional_param('header5', 0, PARAM_INT);
    }
    if (!isset($data->header6)) {
        $data->header6 = optional_param('header6', 0, PARAM_INT);
    }
    if (!isset($data->header7)) {
        $data->header7 = optional_param('header7', 0, PARAM_INT);
    }
    if (!isset($data->header8)) {
        $data->header8 = optional_param('header8', 0, PARAM_INT);
    }

    require_sesskey();

    if ($data->confirm) {
        $importid = $data->importid;
        $importer = new \report_ghs\enrollment_importer(null, null, null, $importid, $data);

        $error = $importer->get_error();
        if ($error) {
            $form = new \report_ghs\form\import($url->out(false));
            $form->set_import_error($error);
        } else {
            $enrollment = $importer->import();
            redirect($redirecturl);
            die();
        }
    } else {
        $text = $form->get_file_content('importfile');
        $encoding = $data->encoding;
        $delimiter = $data->delimiter_name;
        $importer = new \report_ghs\enrollment_importer($text, $encoding, $delimiter);
        $confirmform = new \report_ghs\form\import_confirm(null, $importer);
        $form = $confirmform;

        $pagetitle = get_string('confirmcolumnmappings', 'report_ghs');
    }
}

echo $OUTPUT->header();
echo $OUTPUT->heading($pagetitle);

$form->display();

echo $OUTPUT->footer();
