<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     report_ghs
 * @category    string
 * @copyright   2019 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['pluginname'] = 'GHS Reports';
$string['ghs:viewsla'] = 'View "Waiting for grade" report';
$string['ghs:viewgrades'] = 'View "Student Grades" report';
$string['ghs:viewgradecomparisons'] = 'View "Student Grades" comparison report';
$string['ghs:viewenrollment'] = 'View "User Enrollment" report';
$string['ghs:viewgroupenrollment'] = 'View "Class Enrollment" report';
$string['ghs:viewmissedgrade'] = 'View "Missed grades checker';
$string['ghs:viewenddates'] = 'View "Class End Dates" report';
$string['ghs:uploadgroupenrollment'] = 'Upload group enrollment';
$string['ghs:viewowngroup'] = 'View own group';
$string['ghs:viewallgroups'] = 'View all groups';
$string['ghs:viewowncohort'] = 'View all users in own site cohort';
$string['ghs:viewactivityextensions'] = 'View "Activity Extensions" report';
$string['ghs:groupenrollmentfilter'] = 'View class enrollment filters';
$string['ghs:groupenrollmentexport'] = 'Export report';
$string['ghs:viewadvancedoptions'] = 'View advanced options';
$string['ghs:viewallcourses'] = 'View all courses';
$string['ghs:viewdmoverview'] = 'View DM overview';
$string['ghs:viewenglishproficiencyallschools'] = 'View English Proficiency report for all schools';
$string['ghs:viewenglishproficiencyownschool'] = 'View English Proficiency report for own schools';
$string['ghs:viewclassdeadlinesallschools'] = 'View Class Deadlines for all schools';
$string['ghs:viewclassdeadlinesownschool'] = 'View Class Deadlines report for own schools';
$string['ghs:viewactivityextensionallschools'] = 'View Activity Extensions for all schools';
$string['ghs:viewactivityextensionownschool'] = 'View Activity Extensions report for own schools';
$string['ghs:viewossltengdiscrepancy'] = 'View OSSLT - ENG Grade Discrepancy flag';
$string['ghs:viewclassdeadlines'] = 'View "Class Deadlines" report';
$string['ghs:viewgradingtimemonitor'] = 'View "Grading Time Monitor';
$string['confirmtaskschedulemsg'] = 'It may take up to 15 minutes to generate a new report. You will receive notification when ready. 
Click continue to confirm.';
$string['confirmexportschedulemsg'] = 'It may take up to 15 minutes to export a report. You will receive notification when ready. 
Click continue to confirm.';
$string['taskwarning'] = 'An update task has been scheduled on {$a}. Please come back to this page within 15 min and 
refresh the page to see the updated report.';
$string['exportwarning'] = 'An export request has been scheduled on {$a}.';
$string['taskcreated'] = 'Update request has been scheduled on {$a} successfully.';
$string['lastupdatewarning'] = 'Last update: {$a->lastupdate} Click <a href="{$a->updateurl}">here</a>  to start 
update task now.';
$string['lastupdatewarningshort'] = 'Last update: {$a}';
$string['lastexporttewarning'] = 'Last export: {$a->lastexport} Click <a href="{$a->updateurl}">here</a>  to start 
export task now.';
$string['kica'] = 'KICA';
$string['activity'] = 'Activity';
$string['ghsgrades'] = 'GHS-Grades';
$string['ghsactivity'] = 'GHS-SLA';
$string['ghssubmissions'] = 'GHS-Submissions';
$string['ghsgradechanges'] = 'GHS-Grade-Changes';
$string['rowcount'] = '';
$string['firstname'] = 'Firstname';
$string['lastname'] = 'Lastname';
$string['cohort'] = 'Cohort';
$string['course'] = 'Course';
$string['course_txt'] = 'Course';
$string['category'] = 'Category';
$string['groupname'] = 'Class';
$string['groupname_txt'] = 'Class';
$string['groupnameurl'] = 'Class url';
$string['enrolldate'] = 'Enroll date';
$string['coursegrade'] = 'Moodle Grade';
$string['kicaavg'] = 'KICA Grade';
$string['kica70'] = 'KICA70';
$string['kica30'] = 'KICA30';
$string['kicadiff'] = 'KICA70-30';
$string['export'] = 'Export';
$string['basecategory'] = 'Base cat';
$string['activityname'] = 'Activity name';
$string['numberofdays'] = 'Days';
$string['numberofdaysmoodle'] = 'Days waiting Moodle';
$string['numberofdayskica'] = 'Days waiting KICA';
$string['school'] = 'School';
$string['grader'] = 'OT';
$string['grader_'] = 'Grader';
$string['kicalink'] = 'KICA-Link';
$string['gradebooklink'] = ' Moodle Grade';
$string['kicagradebooklink'] = 'KICA Grade';
$string['activitygradelink'] = 'Activity Grade';
$string['gradestatus'] = 'Grade status';
$string['userstatus'] = 'Student status';
$string['suspendedsite'] = 'Suspended-site';
$string['suspendedcourse'] = 'Suspended-course';
$string['completed'] = 'Completed';
$string['active'] = 'Active';
$string['updatereports'] = 'Update reports';
$string['grade'] = 'Grade';
$string['ghsenrollment'] = 'User Enrollment';
$string['courserole'] = 'Course role';
$string['coursestart'] = 'Enrol Start';
$string['courseend'] = 'Enrol End';
$string['groupstart'] = 'Class Start';
$string['groupend'] = 'Class End';
$string['oen'] = 'OEN';
$string['defaultrole'] = 'Default role';
$string['firstcourse'] = 'First course';
$string['graduation'] = 'Graduation';
$string['program'] = 'Program';
$string['registered'] = 'Registered';
$string['activitytag'] = 'Activity tag';
$string['duedate'] = 'Due';
$string['timesubmission'] = 'Submitted';
$string['timegraded'] = 'Graded';
$string['timegradedmoodle'] = 'Graded Moodle';
$string['timegradedkica'] = 'Graded KICA';
$string['ct'] = 'CT';
$string['ot'] = 'OT';
$string['filter'] = 'Filter';
$string['reset'] = 'Reset';
$string['showall'] = 'Show all';
$string['graded'] = 'Graded';
$string['coursetype'] = 'Course type';
$string['withkica'] = 'with KICA';
$string['withoutkica'] = 'without KICA';
$string['displayingrecords'] = '{$a} records';
$string['all'] = 'All';
$string['ghsgroupenrollment'] = 'Class Enrollment';
$string['coursecode'] = 'Course code';
$string['activestudents'] = 'Active Students';
$string['suspendedstudents'] = 'Suspended students';
$string['ctname'] = 'Classroom Teacher';
$string['otname'] = 'Grading Teacher';
$string['startdate'] = 'Start date';
$string['enddate'] = 'End date';
$string['totaldays'] = 'Total Days';
$string['dmrequired'] = 'DM';
$string['dmstatus'] = 'DM Status';
$string['dmdateconflicts'] = 'DM date conflicts';
$string['enrolldateconflicts'] = 'Enroll date conflicts';
$string['gmessaging'] = 'G Messaging';
$string['subject'] = 'Subject';
$string['grade'] = 'Grade';
$string['department'] = 'Dept';
$string['moe_code'] = 'MOE Code';
$string['moe_name'] = 'MOE Name';
$string['missing'] = 'Missing';
$string['srate'] = 'S-Rate';
$string['frate'] = 'F-Rate';
$string['slaot'] = 'SLA-OT';
$string['finalactivity'] = 'Line';
$string['submissionstatus'] = 'Status';
$string['notsubmitted'] = 'Not Submitted';
$string['submitted'] = 'Submitted';
$string['draft'] = 'Draft';
$string['mid'] = 'Mid';
$string['final'] = 'Final';
$string['importfile'] = 'CSV framework description file';
$string['importfile_help'] = 'A competency framework may be imported via text file. The format of the file can be determined by creating a new competency framework on the site and then exporting it.';
$string['importfile_link'] = 'admin/tool/lpimportcsv';
$string['import'] = 'Import';
$string['confirm'] = 'Confirm';
$string['csvdelimiter'] = 'CSV delimiter';
$string['csvdelimiter_help'] = 'CSV delimiter of the CSV file.';
$string['description'] = 'Description';
$string['descriptionformat'] = 'Description format';
$string['encoding'] = 'Encoding';
$string['encoding_help'] = 'Encoding of the CSV file.';
$string['confirmcolumnmappings'] = 'Confirm the column mappings';
$string['group'] = 'Group';
$string['groupid'] = 'Group ID';
$string['groupidnumber'] = 'Group ID Number';
$string['invalidimportfile'] = 'File format is invalid.';
$string['ghsmissedgrade'] = 'GHS-Missed Grade Checker';
$string['activitygrade'] = 'M-Grade';
$string['kicagrade'] = 'K-Grade';
$string['skipped'] = 'Skipped';
$string['gcomp'] = 'G-Comp';
$string['daysoverdue'] = 'Days overdue';
$string['between199'] = 'Between 1-99%';
$string['none'] = 'None';
$string['zero'] = 'Zero';
$string['hasduedate'] = 'Has due date';
$string['enrolstatus'] = 'Enrol status';
$string['excluded'] = 'Excluded';
$string['excludedgrade'] = 'Excluded grade';
$string['notgraded'] = 'Not graded';
$string['show'] = 'Show';
$string['hide'] = 'Hide';
$string['onedrive'] = 'OneDrive';
$string['username'] = 'Username';
$string['password'] = 'Password';
$string['uploadgroupenrollment'] = 'Upload class enrollment';
$string['syncenroldates'] = 'Sync DM end-date with Enroll end-date';
$string['exportcurrentview'] = 'Export current view';
$string['exportfullreport'] = 'Export full report';
$string['multiplegroupswarning'] = '<i class="fa fa-th-large icon-multiple-groups"></i> One or more students belongs to multiple groups in the same course';
$string['includenoactivestudents'] = 'Include classes with no active students';
$string['past'] = 'Past';
$string['future'] = 'Future';
$string['advancedoptions'] = 'Advanced options';
$string['includeclassesnotactive'] = 'Include classes that are not currently active';
$string['includenoncreditcourses'] = 'Include non-credit courses and resources';
$string['close'] = 'Close';
$string['ghsenddateextension'] = 'Changes to Class End Dates';
$string['class'] = 'Class';
$string['submitter'] = 'Submitter';
$string['changetype'] = 'Change type';
$string['appliedto'] = 'Applied to';
$string['appliedtourl'] = 'Applied to url';
$string['change'] = 'Change';
$string['dateapplied'] = 'Date applied';
$string['reasonprovided'] = 'Reason provided';
$string['classenddate'] = 'Class Enddate';
$string['studentenddate'] = 'Student';
$string['ghsactivityextension'] = 'Activity Extensions';
$string['coursecategories'] = 'Course categories';
$string['student'] = 'Student';
$string['cachedef_group'] = 'Group';
$string['atdiff'] = 'A-T Diff';
$string['assigns'] = 'Assigns';
$string['tests'] = 'Tests';
$string['gt'] = 'GT';
$string['numofclassdays'] = 'Class days';
$string['numofdmdays'] = 'DM days';
$string['incomplete'] = 'Incomplete';
$string['numofsummatives'] = 'Summative activities';
$string['ghsdmoverview'] = 'DM Overview';
$string['dmcomplete'] = 'DM Complete';
$string['knowledge'] = 'Knowledge';
$string['inquiry'] = 'Inquiry';
$string['communication'] = 'Communication';
$string['application'] = 'Application';
$string['clientid'] = 'Client ID';
$string['clientsecret'] = 'Client Secret';
$string['finalgrade'] = 'Final Grade';
$string['lastactivity'] = 'Last activity';
$string['fcategory'] = 'F Category';
$string['lcategory'] = 'L Category';
$string['coursegrade'] = 'Course grade';
$string['academicprogram'] = 'Academic program';
$string['wrongsubmissions'] = 'Wrong submissions';
$string['latesubmissions'] = 'Late submissions';
$string['misseddeadlines'] = 'Missed deadlines';
$string['date'] = 'Date';
$string['gradebefore'] = 'Grade before';
$string['gradeafter'] = 'Grade after';
$string['timedifference'] = 'Hours between change';
$string['ghsenglishproficiency'] = 'English Proficiency Markers';
$string['opt'] = 'OPT';
$string['ossltstatus'] = 'OSSLT Status';
$string['ossltscore'] = 'OSSLT Score';
$string['esldo'] = 'ESLDO';
$string['esleo'] = 'ESLEO';
$string['eng3u'] = 'ENG3U';
$string['eng4u'] = 'ENG4U';
$string['olc4o'] = 'OLC4O';
$string['completedosslteng3u'] = 'Completed OSSLT + ENG3U';
$string['completedosslteng4u'] = 'Completed OSSLT + ENG4U ';
$string['passedosslt'] = 'Passed OSSLT';
$string['failedosslt'] = 'Failed OSSLT';
$string['failedosslteng3uover'] = 'Failed OSSLT + ENG3U grade over 75%';
$string['failedosslteng4uover'] = 'Failed OSSLT + ENG4U grade over 75%';
$string['failedosslteng3ueng4uover'] = 'Failed OSSLT + ENG3U or ENG4U grade over 75%';
$string['syncuserinfodata'] = 'Sync user info data';
$string['ossltyear'] = 'OSSLT Year';
$string['ossltresults'] = 'OSSLT Results';
$string['designation'] = 'Designation';
$string['gradyear'] = 'Grad Year';
$string['esl'] = 'ESL';
$string['nonesl'] = 'Non-ESL';
$string['importenglishproficiency'] = 'English Proficiency Data Import';
$string['imported'] = 'Imported';
$string['importfile'] = 'Import file';
$string['lms'] = 'LMS';
$string['completion'] = 'Completion';
$string['inprogress'] = 'In-progress';
$string['both'] = 'Both';
$string['language'] = 'Language';
$string['coursestatus'] = 'Course Status';
$string['students'] = 'Students';
$string['allstudents'] = 'All students';
$string['completedeng3u'] = 'Completed ENG3U';
$string['completedeng4u'] = 'Completed ENG4U';
$string['eng3ugradeunder75'] = 'ENG3U grade under 75%';
$string['eng3ugradeover75'] = 'ENG3U grade over 75%';
$string['eng4ugradeunder75'] = 'ENG4U grade under 75%';
$string['eng4ugradeover75'] = 'ENG4U grade over 75%';
$string['completedosslt'] = 'Completed OSSLT';
$string['didnotcompleteosslt'] = 'Did not complete OSSLT';
$string['c2'] = 'C2';
$string['c1'] = 'C1';
$string['b2'] = 'B2';
$string['b1'] = 'B1';
$string['a2'] = 'A2';
$string['a1'] = 'A1';
$string['notreported'] = 'Not Reported';
$string['notrequired'] = 'Not Required';
$string['studentsummary'] = 'Student Summary';
$string['ossltsummary'] = 'OSSLT Summary';
$string['studentsselected'] = 'Students selected';
$string['in1Yearprogram'] = 'in 1-Year program';
$string['in2Yearprogram'] = 'in 2-Year Program';
$string['in25Yearprogram'] = 'in 2.5-Year Program';
$string['in3Yearprogram'] = 'in 3-Year Program';
$string['in4Yearprogram'] = 'in 4-Year Program';
$string['withc2opt'] = 'with C2 OPT';
$string['withc1opt'] = 'with C1 OPT';
$string['withb2opt'] = 'with B2 OPT';
$string['withb1opt'] = 'with B1 OPT';
$string['witha2opt'] = 'with A2 OPT';
$string['witha1opt'] = 'with A1 OPT';
$string['withoptnotreported'] = 'with OPT Not Reported';
$string['withoptnotrequired'] = 'with OPT Not Required';
$string['inotherprogram'] = 'In Other Program';
$string['inundeclaredprogram'] = 'In Undeclared Program';
$string['inindependentprogram'] = 'In Independent Program';
$string['innoncredit'] = 'In Non-credit Program';
$string['rawgrade'] = 'Raw Grade';
$string['kicalinkshort'] = 'Link';
$string['status'] = 'Status';
$string['active'] = 'Active';
$string['inactive'] = 'Inactive';
$string['ghsclassdeadlines'] = 'Class Deadlines';
$string['deadline'] = 'Deadline';
$string['deadlinetype'] = 'Deadline Type';
$string['countdown'] = 'Countdown';
$string['activitytype'] = 'Activity type';
$string['assign'] = 'Assignment';
$string['test'] = 'Test';
$string['extension'] = 'Extension';
$string['nextsixtydays'] = 'Next 60 days';
$string['lastsixtydays'] = 'Last 60 days';
$string['period'] = 'Period';
$string['ghsgradingtimemonitor'] = 'Grading time monitor';
$string['periodview'] = 'Period View';
$string['days'] = 'Days';
$string['weeks'] = 'Weeks';
$string['subject'] = 'Subject';
$string['activitytags'] = 'Activity tags';
$string['twoweeks'] = '2 Weeks';
$string['fourweeks'] = '4 Weeks';
$string['lastmonth'] = 'Last month';
$string['lastthreemonth'] = 'Last 3 months';
$string['entiremonth'] = 'Entire year';
$string['gtstatus'] = 'GT Status';
$string['updategtmreport'] = 'Update Grading time monitor report';