/**
 * Contain the logic for a drawer.
 *
 * @module     theme_ned_boost/drawer
 * @package    theme_ned_boost
 * @copyright  NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("theme_ned_boost/ned_drawer",["jquery","core/custom_interaction_events","core/log","core/pubsub","core/aria"],(function($,CustomEvents,Log,PubSub,Aria){var SELECTORS_TOGGLE_REGION=".ned-drawer .dropdown-toggle",SELECTORS_BODY="body",SELECTORS_DRAWER=".ned-drawer .dropdown-menu",small=$(document).width()<768;let Drawer=function(){$(SELECTORS_TOGGLE_REGION).length||Log.debug("Page is missing a drawer region"),$(SELECTORS_TOGGLE_REGION).each(function(index,ele){let trigger=$(ele),drawerid=trigger.attr("aria-controls"),drawer=$(document.getElementById(drawerid)),hidden="false"==trigger.attr("aria-expanded"),body=$(SELECTORS_BODY);document.innerWidth<768&&M.util.set_user_preference("ned-drawer-open-nav","false"),drawer.on("mousewheel DOMMouseScroll",this.preventPageScroll),hidden?(body.removeClass("ned-drawer-open-left"),trigger.attr("aria-expanded","false")):(body.addClass("ned-drawer-open-left"),trigger.attr("aria-expanded","true"))}.bind(this)),this.registerEventListeners(),small&&this.closeAll()};return Drawer.prototype.closeAll=function(){$(SELECTORS_TOGGLE_REGION).each((function(index,ele){let trigger=$(ele).find(SELECTORS_TOGGLE_REGION),body=$(SELECTORS_BODY),drawerid=trigger.attr("aria-controls"),drawer=$(document.getElementById(drawerid));trigger.attr("aria-expanded","false"),body.removeClass("ned-drawer-open-left"),Aria.hide(drawer.get()),drawer.addClass("closed")}))},Drawer.prototype.toggleDrawer=function(e){let trigger=$(e.target),drawerid=trigger.attr("aria-controls"),drawer=$(document.getElementById(drawerid)),body=$(SELECTORS_BODY);body.addClass("drawer-ease");let open="true"==trigger.attr("aria-expanded");open?(body.removeClass("ned-drawer-open-left"),trigger.attr("aria-expanded","false"),drawer.addClass("closed").delay(500).queue((function(){$(this).hasClass("closed")&&Aria.hide(this),$(this).dequeue()}))):(trigger.attr("aria-expanded","true"),Aria.unhide(drawer.get()),drawer.focus(),body.addClass("ned-drawer-open-left"),drawer.removeClass("closed")),PubSub.publish("nav-drawer-toggle-start",open)},Drawer.prototype.preventPageScroll=function(e){let delta=e.wheelDelta||e.originalEvent&&e.originalEvent.wheelDelta||-e.originalEvent.detail,bottomOverflow=this.scrollTop+$(this).outerHeight()-this.scrollHeight>=0,topOverflow=this.scrollTop<=0;(delta<0&&bottomOverflow||delta>0&&topOverflow)&&e.preventDefault()},Drawer.prototype.registerEventListeners=function(){$(SELECTORS_TOGGLE_REGION).each(function(index,element){CustomEvents.define($(element),[CustomEvents.events.activate]),$(element).on(CustomEvents.events.activate,function(e,data){this.toggleDrawer(data.originalEvent),data.originalEvent.preventDefault()}.bind(this))}.bind(this)),$(SELECTORS_DRAWER).on("webkitTransitionEnd msTransitionEnd transitionend",(function(e){var open=!!$(e.target).closest(SELECTORS_DRAWER).attr("aria-hidden");PubSub.publish("nav-drawer-toggle-end",open)}))},{init:function(){return new Drawer}}}));

//# sourceMappingURL=ned_drawer.min.js.map