<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * myprofile rendrer
 *
 * @package    theme_ned_boost
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace theme_ned_boost\output\core_user;
use theme_ned_boost\shared_lib as NED;

defined('MOODLE_INTERNAL') || die;

/** @var \stdClass $CFG */
require_once($CFG->dirroot.'/blocks/moodleblock.class.php');
require_once($CFG->dirroot.'/blocks/badges/block_badges.php');

/**
 * Class myprofile_renderer
 *
 * @package theme_ned_boost\output\core_user
 */
class myprofile_renderer extends \local_ned_controller\output\core_user\myprofile_renderer {
    const PLUGIN = NED::NB;

    /**
     * Render the whole tree.
     *
     * @param \core_user\output\myprofile\tree $tree
     *
     * @return string
     */
    public function render_tree(\core_user\output\myprofile\tree $tree) {
        NED::js_call_amd('my_profile', 'init');
        return parent::render_tree($tree);
    }
}
