<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    theme_ned_boost
 * @subpackage NED Boost
 * @copyright  NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @developer  G J Barnard - {@link http://about.me/gjbarnard} and
 *                           {@link http://moodle.org/user/profile.php?id=442195}
 */

defined('MOODLE_INTERNAL') || die();

$string['configtitle'] = 'NED Boost';
$string['pluginname'] = 'NED Boost';
$string['region-side-pre'] = 'Pre';
$string['region-side-post'] = 'Post';
$string['choosereadme'] = 'NED Boost.';
$string['nedsettings'] = 'NED Settings';
$string['local_ned_controller'] = 'NED Controller';

// Settings.
$string['blockwidthdesc'] = 'Block width in pixels';
$string['both'] = 'Both';
$string['compactlogo'] = 'compact logo:';
$string['courseblockpositions'] = 'Course block positions';
$string['courseblockwidth'] = 'Course block width';
$string['coursehamburgerbutton'] = 'Hamburger button in a course';
$string['courselevel'] = 'Course level';
$string['formatsettings'] = 'Format';
$string['frontpagedashboardblockpositions'] = 'Frontpage/Dashboard block positions';
$string['frontpagedashboardblockwidth'] = 'Frontpage/Dashboard block width';
$string['frontpagedashboardlevel'] = 'Frontpage/Dashboard level';
$string['headerlogo'] = 'Header logo';
$string['ifinstitution'] = 'If Institution = ';
$string['ifthen'] = 'If-then';
$string['userinstitutioncount'] = 'Number of institutions';
$string['userinstitutioncountdesc'] = 'Update and save changes to change the number available.';
$string['left'] = 'Left';
$string['logo'] = 'logo:';
$string['right'] = 'Right';
$string['thenshow'] = 'then show';
$string['userolepermission'] = 'Use role permission';
$string['activitiesandresources'] = 'Activities & Resources';
$string['forwardbacklinks'] = 'Forward/back links';
$string['jumptomenu'] = '\'Jump to...\' menu';
$string['questionnaireactivitylink'] = 'Questionnaire activity - link directly to Questions page';
$string['urlresourcelink'] = 'URL Resource - link directly to URL';
$string['pagedateshowhide'] = 'Show / hide the page module last modified date';

$string['colours'] = 'Colours';
$string['mainbackgroundcolour'] = 'Main background colour';
$string['navdrawerbackgroundcolour'] = 'Top header background colour';
$string['topheadertitletextcolour'] = 'Top header title text colour';
$string['topheadertextcolour'] = 'Top header text colour';
$string['blockheaderbackgroundcolour'] = 'Block header background colour';
$string['blockheadertextcolour'] = 'Block header text colour';
$string['blockbodybackgroundcolour'] = 'Block body background colour';
$string['customiseindividualblocks'] = 'Customise individual blocks';
$string['customiseindividualblocksjsonfail'] = 'Setting value is not in a valid format to be stored.';
$string['customiseindividualblocksformat'] = 'Format: ';
$string['customiseindividualblocksfontawesome'] = 'FontAwesome classes';
$string['customiseindividualblocksblocktype'] = 'Block type';
$string['customiseindividualblockssemi'] = ' and finally a semi-colon \';\' if there is to be another line.  Note: After the FontAwesome classes the colours are optional, to get to a setting without setting the previous use a dash \'-\' for the value.';

$string['customiseindividualblockscolourfail'] = 'Block {$a->blockname} {$a->setting} of \'{$a->value}\' is not a valid colour.  ';
$string['headerbackgroundcolour'] = 'header background colour';
$string['headertextcolour'] = 'header text colour';
$string['bodybackgroundcolour'] = 'body background colour';

// Capabilities.
$string['ned_boost:showavailabilityinfo'] = 'View "Not available..." text beneath restricted activities';
$string['ned_boost:shownavdrawer'] = 'Show hamburger button';
$string['showmyoverview'] = 'Show "Course overview"';
$string['showmyoverviewdesc'] = 'Show "Course overview" block on frontpage or not.';
$string['ned_boost:seeowndashboard'] = 'Student Dashboard: Can see own dashboard';
$string['ned_boost:seeowngroupsdashboards'] = 'Student Dashboard: Can see all students in own course group';
$string['ned_boost:seeowncohortdashboards'] = 'Student Dashboard: Can see all students in own cohort';
$string['ned_boost:seealldashboards'] = 'Student Dashboard: Can see all students in all cohorts';
$string['dashboard'] = 'Dashboard';

$string['myprofilelevelheading'] = 'Profile';

$string['setting:hiddenprofilecategories'] = 'Hidden profile categories';
$string['setting:hiddenprofilecategories:help'] = 'Choose, which categories to hide on the profile page.';

$string['setting:videofield'] = 'Video field';
$string['setting:videofield:help'] = 'Choose field for loading video in the user profiles';
$string['setting:dashboard_course_categories'] = 'Dashboard course categories';
$string['setting:dashboard_course_categories:help'] = 'Course categories, which should be shown on dashboard page';
$string['require_plugin'] = 'Other functions requires {$a->name} {$a->version}';
$string['openbadgepage'] = 'Open badge page';
$string['listall'] = 'List all';
$string['searchclasses'] = 'Search classes';
$string['courses'] = 'Courses';
$string['gradeaverage'] = 'Grade Average';
$string['kicaperformance'] = 'KICA Performance';
$string['participationpower'] = 'Participation Power';
$string['participation'] = 'Participation';
$string['completed'] = 'Completed';
$string['inprogress'] = 'In Progress';
$string['remaining'] = 'Remaining';
$string['overall'] = 'Overall';
$string['low'] = 'Low';
$string['medium'] = 'Medium';
$string['high'] = 'High';
$string['courseoverview'] = 'Course Overview';
$string['onlineteacher'] = 'Online Teacher';
$string['classroomteacher'] = 'Classroom Teacher';
$string['onlineteacher_short'] = 'OT';
$string['classroomteacher_short'] = 'CT';
$string['progress'] = '{$a}% Complete';
$string['showinactivecourses'] = 'Show inactive courses';
$string['hideinactivecourses'] = 'Hide inactive courses';
$string['currentgrade'] = 'Current grade';
$string['enrolltocourses'] = 'Enroll to courses';
$string['badges'] = 'Badges';
$string['calendar'] = 'Important Dates';
$string['allschools'] = 'All Schools';
$string['school'] = 'School';
$string['schoolyear'] = 'School year';
$string['academicprogram'] = 'Academic program';
$string['admissiondate'] = 'Admission date';
$string['expectedgraduation'] = 'Expected graduation';
$string['academicintegrity'] = 'Academic Integrity';
$string['allusers'] = 'All users';
$string['multiple'] = 'multiple';
$string['student'] = 'Student';
$string['cohort'] = 'Cohort';
$string['pagetype_people'] = 'People';
$string['pagetype_dn'] = 'Deadline Notifications';
$string['no_dn_data'] = 'There are no Deadline Notifications';
$string['myschool'] = 'My School';
$string['mydashboard'] = 'My Dashboard';
$string['studentdashboards'] = 'Student Dashboards';
$string['schools'] = 'Schools';
$string['logosheading'] = 'Logos';
$string['setting:logo'] = 'Logo';
$string['setting:logo:help'] = 'Site header logo';
$string['setting:loginlogo'] = 'Login page logo';
$string['setting:loginlogo:help'] = '';
$string['loginheaderbackgroundcolour'] = 'Login header background colour';