<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    theme_ned_boost
 * @subpackage NED Boost
 * @copyright  NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @developer  G J Barnard - {@link http://about.me/gjbarnard} and
 *                           {@link http://moodle.org/user/profile.php?id=442195}
 */

defined('MOODLE_INTERNAL') || die();

if ($CFG->branch >= 35) {
    $PAGE->navbar->add(get_string('myschool', 'theme_ned_boost'));

    // block myoverview was added in the theme/ned_boost/lib.php: theme_ned_boost_page_init()
    // block myoverview was removed from its region in theme/ned_boost/classes/output/core_renderer.php: block()
    $templatecontext = $OUTPUT->get_frontdashboard_context();
    $templatecontext['myoverview'] = '';
    $myoverview_name = 'myoverview';

    if (theme_ned_boost_should_add_showmyoverview_block() and $PAGE->blocks->is_block_present($myoverview_name)){
        $blocks = $PAGE->blocks->get_blocks_for_region('side-post');
        $myoverview_block = null;
        foreach ($blocks as $block){
            if ($block->instance->blockname == $myoverview_name){
                $myoverview_block = $block;
                break;
            }
        }
        if ($myoverview_block){
            $templatecontext['myoverview'] = $OUTPUT->block($myoverview_block->get_content_for_output($OUTPUT), 'main');
        }
    }
    if (has_capability('assignsubmission/ctsubmission:viewsubmissionalertsite', \context_system::instance(), null, false)
        && class_exists('assignsubmission_ctsubmission\\output\\renderer'))  {
        $ctrenderer = $PAGE->get_renderer('assignsubmission_ctsubmission');
        if ($notification = $ctrenderer->render(new \assignsubmission_ctsubmission\output\ct_alert())) {
            \core\notification::error($notification);
        }
    }
    echo $OUTPUT->render_from_template('theme_ned_boost/dynamiclayout', $templatecontext);
} else {
    echo $OUTPUT->render_from_template('theme_ned_boost/dynamiclayout_old', $OUTPUT->get_frontdashboard_context());
}

