<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    theme_ned_boost
 * @subpackage NED Boost
 * @copyright  NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @developer  G J Barnard - {@link http://about.me/gjbarnard} and
 *                           {@link http://moodle.org/user/profile.php?id=442195}
 */

use theme_ned_boost\shared_lib as NED;

defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot . '/theme/ned_boost/lib.php');

if ($hassiteconfig || has_capability('theme/boost_union:configure', context_system::instance())) {

    $mainsettingspageurl = new moodle_url('/admin/settings.php', ['section' => 'themesettingned_boost']);
    if ($ADMIN->fulltree && $PAGE->has_set_url() && $PAGE->url->compare($mainsettingspageurl)) {
        redirect(new moodle_url('/admin/settings.php', ['section' => 'theme_ned_boost']));
    }

    // Create empty settings page structure to make the site administration work on non-admin pages.
    if (!$ADMIN->fulltree) {
        // Create NED Boost settings page
        // (and allow users with the theme/boost_union:configure capability to access it).
        $tab = new admin_settingpage('theme_ned_boost',
            get_string('configtitle', 'theme_ned_boost', null, true),
            'theme/boost_union:configure');
        $ADMIN->add('theme_boost_union', $tab);
    }

    // Create full settings page structure.
    // @codingStandardsIgnoreLine
    else if ($ADMIN->fulltree) {

        // Require the necessary libraries.
        require_once($CFG->dirroot . '/theme/boost_union/lib.php');
        require_once($CFG->dirroot . '/theme/boost_union/locallib.php');
        require_once($CFG->dirroot . '/theme/ned_boost/lib.php');
        require_once($CFG->dirroot . '/theme/ned_boost/local_lib.php');

        // Prepare options array for select settings.
        // Due to MDL-58376, we will use binary select settings instead of checkbox settings throughout this theme.
        $yesnooption = [THEME_BOOST_UNION_SETTING_SELECT_YES => get_string('yes'),
            THEME_BOOST_UNION_SETTING_SELECT_NO => get_string('no'),];


        // Create NED Boost settings page with tabs
        // (and allow users with the theme/boost_union:configure capability to access it).
        $page = new theme_boost_admin_settingspage_tabs('theme_ned_boost',
            get_string('configtitle', 'theme_ned_boost', null, true),
            'theme/boost_union:configure');

        // Format tab.
        $tab = new admin_settingpage(NED::$PLUGIN_NAME . '_format', NED::str('formatsettings'));

        // Logo file setting.
        $tab->add(new admin_setting_heading(NED::$PLUGIN_NAME . '_logosheading',
            NED::str('logosheading'), ''));

        $name = NED::$PLUGIN_NAME . '/logo';
        $title = NED::str('setting:logo');
        $description = NED::str('setting:logo:help');
        $setting = new admin_setting_configstoredfile($name, $title, $description, 'logo', 0,
            ['maxfiles' => 1, 'accepted_types' => ['.jpg', '.png']]);
        $setting->set_updatedcallback('theme_reset_all_caches');
        $tab->add($setting);

        // Logo for login page.
        $name = NED::$PLUGIN_NAME . '/loginlogo';
        $title = NED::str('setting:loginlogo');
        $description = NED::str('setting:loginlogo:help');
        $setting = new admin_setting_configstoredfile($name, $title, $description, 'loginlogo', 0,
            ['maxfiles' => 1, 'accepted_types' => ['.jpg', '.png']]);
        $setting->set_updatedcallback('theme_reset_all_caches');
        $tab->add($setting);

        // My profile
        $tab->add(new admin_setting_heading(NED::$PLUGIN_NAME . '_myprofilelevelheading',
            NED::str('myprofilelevelheading'), ''));

        // Show profile categories
        $name = NED::$PLUGIN_NAME . '/hiddenprofilecategories';
        $title = NED::str('setting:hiddenprofilecategories');
        $description = NED::str('setting:hiddenprofilecategories:help');
        $choices = NED::get_myprofile_categories();
        if (!empty($choices)) {
            $default = [];
            $setting = new admin_setting_configmulticheckbox($name, $title, $description, $default, $choices);
            $tab->add($setting);
        }

        // Video field in user profile
        $name = NED::$PLUGIN_NAME . '/videofield';
        $title = NED::str('setting:videofield');
        $description = NED::str('setting:videofield:help');
        $choices = NED::get_possible_videofields();
        $default = 0;
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
        $setting->set_updatedcallback(NED::$PLUGIN_NAME . '_change_videofield');
        $tab->add($setting);

        // Frontpage / dashboard level.
        $tab->add(new admin_setting_heading(NED::$PLUGIN_NAME . '_frontpagedashboardlevelheading',
            NED::str('frontpagedashboardlevel'), ''));

        // Show myoverview on frontpage
        $name = NED::$PLUGIN_NAME . '/showmyoverview';
        $title = NED::str('showmyoverview');
        $description = NED::str('showmyoverviewdesc');
        $setting = new admin_setting_configcheckbox($name, $title, $description, 0);
        $tab->add($setting);

        // Block width.
        $name = NED::$PLUGIN_NAME . '/frontpagedashboardlevelblockwidth';
        $title = NED::str('frontpagedashboardblockwidth');
        $description = NED::str('blockwidthdesc');
        $default = 350;
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_INT);
        $setting->set_updatedcallback('theme_reset_all_caches');
        $tab->add($setting);

        // Block positions.
        $name = NED::$PLUGIN_NAME . '/frontpagedashboardlevelblockpositions';
        $title = NED::str('frontpagedashboardblockpositions');
        $description = '';
        $choices = array(
            1 => NED::str('both'),
            2 => NED::str('right'),
            3 => NED::str('left')
        );
        $default = 2;
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
        $setting->set_updatedcallback('theme_reset_all_caches');
        $tab->add($setting);

        // Dashboard
        $tab->add(new admin_setting_heading('theme_ned_boost_dashboard',
            NED::str('dashboard'), ''));

        // Show profile categories
        $course_types = theme_ned_boost\output\frontdashboard::get_course_types();
        if ($course_types) {
            $name = NED::$PLUGIN_NAME . '/dashboard_course_categories';
            $title = NED::str('setting:dashboard_course_categories');
            $description = NED::str('setting:dashboard_course_categories:help');
            $default = [reset($course_types)];
            $setting = new admin_setting_configmulticheckbox($name, $title, $description, $default, $course_types);
            $tab->add($setting);
        }

        $page->add($tab);

        // Colours.
        $tab = new admin_settingpage(NED::$PLUGIN_NAME . '_colours', NED::str('colours'));

        $color_settings = [
            // Main background colour setting.
            'mainbackgroundcolour' => '#eceeef',
            // Nav-drawer background colour setting.
            'navdrawerbackgroundcolour' => '#dce0e2',
            // Login Header background colour setting.
            'loginheaderbackgroundcolour' => '#ffffff',
            // Top header title text colour setting.
            'topheadertitletextcolour' => '#373a3c',
            // Top header text colour setting.
            'topheadertextcolour' => '#1177d1',
            // Block header background colour setting.
            'blockheaderbackgroundcolour' => '#dce0e2',
            // Block header text colour setting.
            'blockheadertextcolour' => '#333333',
        ];

        foreach ($color_settings as $set_name => $def_color) {
            $name = NED::$PLUGIN_NAME . '/' . $set_name;
            $title = NED::str($set_name);
            $description = '';
            $default = $def_color;
            $previewconfig = null;
            $setting = new admin_setting_configcolourpicker($name, $title, $description, $default, $previewconfig);
            $setting->set_updatedcallback('theme_reset_all_caches');
            $tab->add($setting);
        }

        NED::require_file('~ned_boost_admin_setting_customiseindividualblocks.php');

        // Customise individual blocks setting.
        $name = NED::$PLUGIN_NAME . '/customiseindividualblocks';
        $title = NED::str('customiseindividualblocks');
        $description = NED::str('customiseindividualblocksformat') .
            NED::str('customiseindividualblocksblocktype') . ', ' .
            NED::str('customiseindividualblocksfontawesome') . ', ' .
            NED::str('blockheaderbackgroundcolour') . ', ' .
            NED::str('blockheadertextcolour') . ', ' .
            NED::str('blockbodybackgroundcolour') .
            NED::str('customiseindividualblockssemi');
        $default = 'poll, fa fa-comment, #dc8d55, #ffffff;' . PHP_EOL . 'login, fa fa-user, #e04f42, #ffffff, #ffffff';
        $setting = new ned_boost_admin_setting_customiseindividualblocks($name, $title, $description, $default);
        $setting->set_updatedcallback('theme_reset_all_caches');
        $tab->add($setting);

        $page->add($tab);

        // Add settings page to the admin settings category.
        $ADMIN->add('theme_boost_union', $page);
    }
}
