define(['jquery'], function($) {
    return {
        init: function(scheme, host, path, params) {
            if (!scheme || !host || !path || !params){
                return;
            }
            $(document).ready(function(){
                let $mm_link = $('.theme_ned_classic_grading_app a.marking-manager');
                $mm_link.bind('click', function(e){
                    let $user_info = $('[data-region="user-info"]');
                    if (!$user_info.length){
                        return false;
                    }
                    // don't use .data here, it returns wrong result
                    params['group'] = $user_info.attr('data-groupid');
                    params['setuser'] = $user_info.attr('data-userid');
                    let s_params = [];
                    for(let key in params){
                        if (!params.hasOwnProperty(key)){
                            continue;
                        }
                        s_params.push(key + '=' + params[key]);
                    }

                    $mm_link.attr('href', scheme + '://' + host + path + '?' + s_params.join('&'));
                    return true;
                });
            });
        }
    };
});