define(['jquery', 'local_ned_controller/show_ned_notify', 'core/str'], function($, NED_Notify, Str) {
    let ready_to_go = false;
    return {
        init: function(warning, plain_warning='') {
            plain_warning = plain_warning || (warning.message || warning);
            $(document).ready(function(){
                Str.get_string('logout', 'moodle', '', '').then((logout_str) => {
                    const sel_a_not = `[href^="#"], :contains(${logout_str}), .download, .glossary.autolink, .fileuploadsubmission>a, .cls-action>a`;
                    const sel = `a:not(${sel_a_not}), button, input[type="button"], input[type="submit"]`;
                    const elems_allow_to_go = $(document).find('div[role="main"] form input, div[role="main"] form button');

                    $(document).find(sel).bind('click', function(e){
                        if (elems_allow_to_go.is(e.target)){
                            ready_to_go = true;
                        } else {
                            e.preventDefault();
                            ready_to_go = false;
                            if (typeof warning === 'string'){
                                alert(warning);
                            } else {
                                NED_Notify.show(warning)
                            }
                        }

                        return ready_to_go;
                    });
                });
            });

            window.addEventListener('beforeunload', function (e) {
                if (!ready_to_go){
                    e.returnValue = plain_warning || '';
                    return e.returnValue;
                }
            });
        }
    };
});