<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file.
 *
 * @package   theme_ned_classic
 * @copyright 2018 Bas Brands
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// This line protects the file from being accessed by a URL directly.
defined('MOODLE_INTERNAL') || die();

// Raw SCSS setting.
$string['choosereadme'] = 'NED Classic is a highly-customisable theme, based on Boost, with an alternative navigation layout. This theme is intended to be used directly, or as a parent theme when creating or updating custom themes to utilise Bootstrap 4.';
$string['configtitle'] = 'NED Classic';
$string['navbardark'] = 'Use a dark style navbar';
$string['navbardarkdesc'] = 'Swaps text and background colours for the navbar at the top of the page between dark and light.';
$string['pluginname'] = 'NED Classic';
$string['presetfiles'] = 'Additional theme preset files';
$string['presetfiles_desc'] = 'Preset files can be used to dramatically alter the appearance of the theme. See <a href="https://docs.moodle.org/dev/Boost_Presets">Boost presets</a> for information on creating and sharing your own preset files, and see the <a href="https://archive.moodle.net/boost">Presets repository</a> for presets that others have shared.';
$string['preset'] = 'Theme preset';
$string['preset_desc'] = 'Pick a preset to broadly change the look of the theme.';
$string['privacy:metadata'] = 'The NED Classic theme does not store any personal data.';
$string['region-side-post'] = 'Right';
$string['region-side-pre'] = 'Left';
$string['sitetitle'] = 'Site title';
$string['totop'] = 'Go to top';

$string['region-side-pre'] = 'Pre';
$string['region-side-post'] = 'Post';
$string['choosereadme'] = 'NED Classic';
$string['local_ned_controller'] = 'NED Controller';

// Settings.
$string['activitiesandresources'] = 'Activities & Resources';
$string['custom'] = 'Custom';
$string['forwardbacklinks'] = 'Forward/back links';
$string['jumptomenu'] = '\'Jump to...\' menu';
$string['pagedateshowhide'] = 'Show / hide the page module last modified date';
$string['questionnaireactivitylink'] = 'Questionnaire activity - link directly to Questions page';
$string['urlresourcelink'] = 'URL Resource - link directly to URL';

// From theme_ned_classic
$string['customcss'] = 'Custom CSS';
$string['customcssdesc'] = 'Whatever CSS rules you add to this textarea will be reflected in every page, making for easier customization of this theme.';

$string['footnote'] = 'Footnote';
$string['footnotedesc'] = 'Whatever you add to this textarea will be displayed in the footer throughout your Moodle site.';

$string['invert'] = 'Invert navbar';
$string['invertdesc'] = 'Swaps text and background for the navbar at the top of the page between black and white.';

$string['logo'] = 'Logo';
$string['logodesc'] = 'The logo is only displayed in the header of the front page and login page.<br /> If the height of your logo is more than 75px add div.logo {height: 100px;} to the Custom CSS box below, amending accordingly if the height is other than 100px. If a logo is not added here, the logo in Appearance > Logos will be used.';

$string['privacy:metadata'] = 'The Classic theme does not store any personal data about any user.';

$string['sitelogo'] = 'Site logo';
$string['sitename'] = 'Display site name along with small logo';
$string['sitenamedesc'] = 'If there is no small logo, the site name is always displayed in the navigation bar. If a small logo is set, it may be displayed with or without the site name.';
$string['smalllogo'] = 'Small logo';
$string['smalllogodesc'] = 'The small logo is displayed in the navigation bar. If there is a header logo for the front page and login page, the small logo is not displayed on these pages. If a logo is not added here, the compact logo in Appearance > Logos will be used.';

// Block
$string['addtodock'] = 'Move this to the dock';
$string['dockblock'] = 'Dock {$a} block';
$string['hideblock'] = 'Hide {$a} block';
$string['undockitem'] = 'Undock this item';
$string['undockall'] = 'Undock all';
$string['undockblock'] = 'Undock {$a} block';
$string['hidedockpanel'] = 'Hide the dock panel';
$string['hidepanel'] = 'Hide panel';

// Form
$string['required'] = 'Required field';
$string['advanced'] = 'Advanced element';

$string['myprofilelevelheading'] = 'Profile';
$string['othersettings'] = 'Other Settings';

$string['setting:hiddenprofilecategories'] = 'Hidden profile categories';
$string['setting:hiddenprofilecategories:help'] = 'Choose, which categories to hide on the profile page.';

$string['setting:videofield'] = 'Video field';
$string['setting:videofield:help'] = 'Choose field for loading video in the user profiles';

$string['assign_warning'] = "You haven't submitted your submission!";
$string['require_plugin'] = 'Other functions requires {$a->name} {$a->version}';
$string['openbadgepage'] = 'Open badge page';
$string['worksheetquestionid'] = 'Worksheet Question ID';
$string['answeredonworksheet'] = 'Answered on worksheet';

$string['customquiz'] = 'Custom Quiz settings';
$string['customquiz_preventchangetext'] = 'Prevent change text';
$string['customquiz_preventchangetext_help'] = 'Prevent cut/copy/paste text in the quizzes for students.';
$string['customquiz_hideheader'] = 'Hide header';
$string['customquiz_hideheader_help'] = 'Hide the right part of the header on the quiz pages.';
$string['customquiz_checkbrowser'] = 'Check browser';
$string['customquiz_checkbrowser_help'] = 'Check, that user (not admin) use desktop Chrome in the quizzes, which have “OBS-LTVQ” or “LVQ” tag.';
$string['customquiz_checkbrowser_error'] = '<p>
You must use desktop Chrome browser for all Tests and Live Records. 
Please switch browser/device and return to this activity.
</p>
<p><a href="https://www.google.com/chrome/" target="_blank">Download Chrome</a></p>
';

$string['warning_active_assign_filter'] = 'Attention, you have a student filter active.';
$string['active_assign_filter_name'] = 'According to it, a student\'s first name must begin with "{$a}".';
$string['active_assign_filter_surname'] = 'According to it, a student\'s last name must begin with "{$a}".';
$string['active_assign_filter_both_names'] = 'According to it, a student\'s first name must begin with "{$a->i_first}", ' .
    'and last name must begin with "{$a->i_last}".';
$string['assign_filter_click_here_reset'] = 'Click on this message to reset the filter and see all submissions.';
$string['assignconfirmation1'] = 'You are about to submit these files. Please review to make sure that they are the correct files for this activity.';
$string['assignconfirmation2'] = 'If you need to replace any of the files above, please click the cancel button below and try again.';
$string['reviewsubmission'] = 'Click here to review your submission';

$string['showttmb'] = 'Show TT Menu Bar';
$string['hidettmb'] = 'Hide TT Menu Bar';
